;; A simple program to display "Hello World". This program
;; will work with CP/M 2.1 and C/PM +
;;
;; This program uses BIOS function CONOUT

;; origin for CP/M programs
org &100
nolist
write"cpmex2.com"

;;---------------------------------------------------------
;; BIOS FUNCTION offsets

.cpm_wboot equ 0
.cpm_const equ 3
.cpm_conin equ 6
.cpm_conout equ 9
.cpm_list equ 12
.cpm_punch equ 15
.cpm_reader equ 18
.cpm_home equ 21
.cpm_seldsk equ 24
.cpm_settrk equ 27
.cpm_setsec equ 30
.cpm_setdma equ 33
.cpm_read equ 36
.cpm_write equ 39
.cpm_listst equ 42
.cpm_sectran equ 45

;;---------------------------------------------------------
;; display message and then return back to the command-line

ld hl,message
call display_message
ret

;;---------------------------------------------------------
;; HL = pointer to null terminated message
.display_message
ld a,(hl)				;; get ASCII character
inc hl					;; increment pointer for next character
or a					;; end of message marker (0)?
ret z					;; quit if end of message marker found.

call display_char		;; send character to console output
jp display_message		;; loop for next char


;;---------------------------------------------------------
;; display char using BIOS function CONOUT
;;
;; A = ASCII character

.display_char
push hl
push de
push bc
call do_conout
pop bc
pop de
pop hl
ret

;;---------------------------------------------------------
;; A = ASCII character
.do_conout
ld de,cpm_conout
ld c,a
ld hl,(1)				;; address of JP BOOT entry in table
add hl,de				;; add on offset
jp (hl)

;;---------------------------------------------------------
;; the message to display

.message
defb "Hello World!",0


